<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2013 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

class DBTechvBDownloads_Api_vBDownloads_Import
{
	/**
	* What step we're currently running
	*
	* @protected	integer
	*/
	protected $_step 		= 1;
	
	/**
	* List of all possible modifications to import
	*
	* @protected	array
	*/
	protected $_providers 	= array();

	/**
	* Determines our environment and initialises the process
	*/
	public function __construct()
	{
		global $vbulletin, $vbphrase;

		if ($step = $vbulletin->input->clean_gpc('r', 'step', TYPE_UINT))
		{
			// Set the step
			$this->_step = $step;
		}

		$method = 'step' . $this->_step;
		if (!method_exists($this, $method))
		{
			// We didn't have this step
			print_stop_message('dbtech_downloads_invalid_x', $vbphrase['dbtech_downloads_import_step'], $this->_step);
		}

		if (get_class($this) == get_class() OR $this->_step != 1)
		{
			if ($this->_step != 1)
			{
				// We're only doing this for actual import steps
				$this->_printHeader();
			}

			try
			{
				// Execute our current step
				$this->$method();
			}
			catch (Exception $e)
			{
				print_description_row($e->getMessage());
				print_table_footer();
				return;
			}

			if ($this->_step != 1)
			{
				// We're only doing this for actual import steps
				$this->_printFooter();
			}
		}
	}

	/**
	* This is the "Select what mod to import from" step.
	* Should never be overridden by subclasses.
	*/
	private function step1()
	{
		global $vbulletin, $vbphrase;

		// Normal icons
		$d = dir(DIR . '/dbtech/downloads/includes/import');
		while (false !== ($file = $d->read()))
		{
			if ($file != '.' AND $file != '..' AND $file != 'index.html')
			{
				// Grab the file
				require_once(DIR . '/dbtech/downloads/includes/import/' . $file);

				$file = pathinfo($file, PATHINFO_FILENAME);

				// Initialise our class to find out what's what
				$classname = 'DBTechvBDownloads_Api_vBDownloads_Import_' . ucfirst($file);
				$tmp = new $classname();

				// Add it to the list of providers
				$this->_providers[$file] = $tmp->identifier;

				// Get rid of our temp class
				unset($tmp);
			}
		}
		$d->close();

		$tableNames = $modNames = array();
		foreach ($this->_providers as $file => $info)
		{
			// Ensure we have this right
			$tableNames[] = TABLE_PREFIX . $info['table'];
			$modNames[$file] = $info['title'];
		}

		// Grab all our DB
		$tables = VBDOWNLOADS::$db->fetchAll('
			SELECT table_name
			FROM information_schema.tables
			WHERE table_schema = ?
				AND table_name :queryList
		', array(
			$vbulletin->config['Database']['dbname'],
			':queryList' => VBDOWNLOADS::$db->queryList($tableNames)
		));

		print_form_header('vbdownloads', 'import');
		construct_hidden_code('step', $this->_step + 1);
		print_table_header($vbphrase['dbtech_downloads_import_utility']);

		if (!$tables)
		{
			print_description_row(construct_phrase($vbphrase['dbtech_downloads_no_mods_found_supported_x'], '<li>' . implode('</li><li>', $modNames) . '</li>'));
			print_table_footer();
			return;
		}

		print_select_row($vbphrase['dbtech_downloads_choose_mod_to_import'], 'mod', $modNames);
		print_submit_row($vbphrase['import'], false);
	}

	/**
	* Shorthand for printing the table / form header
	*/
	protected function _printHeader()
	{
		global $vbphrase;

		print_form_header('vbdownloads', 'import');
		construct_hidden_code('step', $this->_step + 1);
		construct_hidden_code('mod', $this->identifier['mod']);
		print_table_header(construct_phrase($vbphrase['dbtech_downloads_importing_from_x_step_y'], $this->identifier['title'], $this->_step));
	}

	/**
	* Shorthand for printing the table / form footer
	*/
	protected function _printFooter()
	{
		global $vbphrase;

		print_submit_row($vbphrase['continue'], false);
	}
}

?>